#ifndef _DIALOGS_SPLASH_CPP
#define _DIALOGS_SPLASH_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HWND SplashProgress_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK SplashDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND VersionTag_hWnd     = NULL;

    static int StatusPos = 0;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        StatusPos = 0;

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)"Loading...");
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        SplashProgress_hWnd = GetDlgItem(xHandle, IDC_SPLASHPROGRESS);
        VersionTag_hWnd     = GetDlgItem(xHandle, IDC_VERSIONTAG);

        char VersionTag[255];
        sprintf(VersionTag, "%s [Version: %s]", gsTitleCaption, gsFileVersion);
        Set_Text(VersionTag_hWnd, VersionTag);

        SetTimer(xHandle, 0, 25, NULL);

        CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CTLCOLORSTATIC)
    {
        if((HANDLE)lParam == VersionTag_hWnd)
            return Set_Color(RGB(255, 0, 0), RGB(255, 255, 255), wParam);

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_TIMER)
    {
        StatusPos = (StatusPos + 2);
        SendMessage(SplashProgress_hWnd, (UINT)PBM_SETPOS, (WPARAM)StatusPos, (LPARAM)0);

        if(StatusPos >= 100)
        {
            StatusPos = 0;
            KillTimer(xHandle, 0);
            EndDialog(xHandle,0);
            DestroyWindow(xHandle);
            SetForegroundWindow(MainDialog_hWnd);
        }

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        KillTimer(xHandle, 0);
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

